/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.compile.incremental.asm;

import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.lang.annotation.RetentionPolicy;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Predicate;
import org.gradle.api.internal.cache.StringInterner;
import org.gradle.api.internal.initialization.transform.utils.ClassAnalysisUtils;
import org.gradle.api.internal.tasks.compile.incremental.asm.BootstrapMethod;
import org.gradle.api.internal.tasks.compile.incremental.asm.ClassRelevancyFilter;
import org.gradle.api.internal.tasks.compile.incremental.deps.ClassAnalysis;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ConstantDynamic;
import org.objectweb.asm.Handle;
import org.objectweb.asm.Label;
import org.objectweb.asm.ModuleVisitor;
import org.objectweb.asm.Type;
import org.objectweb.asm.TypePath;
import org.objectweb.asm.signature.SignatureReader;
import org.objectweb.asm.signature.SignatureVisitor;

public class ClassDependenciesVisitor
extends ClassVisitor {
    private static final int API = 589824;
    private static final Handle CONSTANT_BOOTSTRAPS_INVOKE = new Handle(6, "java/lang/invoke/ConstantBootstraps", "invoke", "(Ljava/lang/invoke/MethodHandles$Lookup;Ljava/lang/String;Ljava/lang/Class;Ljava/lang/invoke/MethodHandle;[Ljava/lang/Object;)Ljava/lang/Object;", false);
    private static final Handle CLASS_DESC_OF = new Handle(6, "java/lang/constant/ClassDesc", "of", "(Ljava/lang/String;)Ljava/lang/constant/ClassDesc;", true);
    private final IntSet constants = new IntOpenHashSet(2);
    private final Set<String> privateTypes = new HashSet<String>();
    private final Set<String> accessibleTypes = new HashSet<String>();
    private final Predicate<String> typeFilter;
    private final StringInterner interner;
    private boolean isAnnotationType;
    private String dependencyToAllReason;
    private String moduleName;
    private final RetentionPolicyVisitor retentionPolicyVisitor = new RetentionPolicyVisitor();

    private ClassDependenciesVisitor(Predicate<String> typeFilter, ClassReader reader, StringInterner interner) {
        super(589824);
        this.typeFilter = typeFilter;
        this.interner = interner;
        this.collectRemainingClassDependencies(reader);
    }

    public static ClassAnalysis analyze(String className, ClassReader reader, StringInterner interner) {
        ClassDependenciesVisitor visitor = new ClassDependenciesVisitor(new ClassRelevancyFilter(className), reader, interner);
        reader.accept((ClassVisitor)visitor, 4);
        visitor.privateTypes.removeAll(visitor.accessibleTypes);
        String name = visitor.moduleName != null ? visitor.moduleName : className;
        return new ClassAnalysis(interner.intern(name), visitor.getPrivateClassDependencies(), visitor.getAccessibleClassDependencies(), visitor.getDependencyToAllReason(), visitor.getConstants());
    }

    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        this.isAnnotationType = this.isAnnotationType(interfaces);
        Set<String> types = ClassDependenciesVisitor.isAccessible(access) ? this.accessibleTypes : this.privateTypes;
        this.maybeAddClassTypesFromSignature(signature, types);
        if (superName != null) {
            Type type = Type.getObjectType((String)superName);
            this.maybeAddDependentType(types, type);
        }
        for (String s : interfaces) {
            Type interfaceType = Type.getObjectType((String)s);
            this.maybeAddDependentType(types, interfaceType);
        }
    }

    public ModuleVisitor visitModule(String name, int access, String version) {
        this.moduleName = name;
        this.dependencyToAllReason = "module-info of '" + name + "' has changed";
        return null;
    }

    private void collectRemainingClassDependencies(ClassReader reader) {
        ClassAnalysisUtils.getClassDependencies((ClassReader)reader, classDescriptor -> {
            Type type = Type.getObjectType((String)classDescriptor);
            this.maybeAddDependentType(this.privateTypes, type);
        });
    }

    private void maybeAddClassTypesFromSignature(String signature, final Set<String> types) {
        if (signature != null) {
            SignatureReader signatureReader = new SignatureReader(signature);
            signatureReader.accept(new SignatureVisitor(589824){

                public void visitClassType(String className) {
                    Type type = Type.getObjectType((String)className);
                    ClassDependenciesVisitor.this.maybeAddDependentType(types, type);
                }
            });
        }
    }

    protected void maybeAddDependentType(Set<String> types, Type type) {
        while (type.getSort() == 9) {
            type = type.getElementType();
        }
        if (type.getSort() != 10) {
            return;
        }
        String name = type.getClassName();
        if (this.typeFilter.test(name)) {
            types.add(this.interner.intern(name));
        }
    }

    public Set<String> getPrivateClassDependencies() {
        return this.privateTypes;
    }

    public Set<String> getAccessibleClassDependencies() {
        return this.accessibleTypes;
    }

    public IntSet getConstants() {
        return this.constants;
    }

    private boolean isAnnotationType(String[] interfaces) {
        return interfaces.length == 1 && interfaces[0].equals("java/lang/annotation/Annotation");
    }

    public FieldVisitor visitField(int access, String name, String desc, String signature, Object value) {
        Set<String> types = ClassDependenciesVisitor.isAccessible(access) ? this.accessibleTypes : this.privateTypes;
        this.maybeAddClassTypesFromSignature(signature, types);
        this.maybeAddDependentType(types, Type.getType((String)desc));
        if (ClassDependenciesVisitor.isAccessibleConstant(access, value)) {
            this.constants.add((name + '|' + value).hashCode());
        }
        return new FieldVisitor(types);
    }

    public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
        Set<String> types = ClassDependenciesVisitor.isAccessible(access) ? this.accessibleTypes : this.privateTypes;
        this.maybeAddClassTypesFromSignature(signature, types);
        this.addTypesFromMethodDescriptor(types, desc);
        return new MethodVisitor(types);
    }

    private void addTypesFromMethodDescriptor(Set<String> types, String desc) {
        Type methodType = Type.getMethodType((String)desc);
        this.maybeAddDependentType(types, methodType.getReturnType());
        for (Type argType : methodType.getArgumentTypes()) {
            this.maybeAddDependentType(types, argType);
        }
    }

    public org.objectweb.asm.AnnotationVisitor visitAnnotation(String desc, boolean visible) {
        if (this.isAnnotationType && "Ljava/lang/annotation/Retention;".equals(desc)) {
            return this.retentionPolicyVisitor;
        }
        this.maybeAddDependentType(this.accessibleTypes, Type.getType((String)desc));
        return new AnnotationVisitor(this.accessibleTypes);
    }

    private static boolean isAccessible(int access) {
        return (access & 2) == 0;
    }

    private static boolean isAccessibleConstant(int access, Object value) {
        return ClassDependenciesVisitor.isConstant(access) && ClassDependenciesVisitor.isAccessible(access) && value != null;
    }

    private static boolean isConstant(int access) {
        return (access & 0x10) != 0 && (access & 8) != 0;
    }

    public String getDependencyToAllReason() {
        return this.dependencyToAllReason;
    }

    private class RetentionPolicyVisitor
    extends org.objectweb.asm.AnnotationVisitor {
        public RetentionPolicyVisitor() {
            super(589824);
        }

        public void visitEnum(String name, String desc, String value) {
            RetentionPolicy policy;
            if ("Ljava/lang/annotation/RetentionPolicy;".equals(desc) && (policy = RetentionPolicy.valueOf(value)) == RetentionPolicy.SOURCE) {
                ClassDependenciesVisitor.this.dependencyToAllReason = "source retention annotation '" + name + "' has changed";
            }
        }
    }

    private class FieldVisitor
    extends org.objectweb.asm.FieldVisitor {
        private final Set<String> types;

        public FieldVisitor(Set<String> types) {
            super(589824);
            this.types = types;
        }

        public org.objectweb.asm.AnnotationVisitor visitAnnotation(String descriptor, boolean visible) {
            ClassDependenciesVisitor.this.maybeAddDependentType(this.types, Type.getType((String)descriptor));
            return new AnnotationVisitor(this.types);
        }

        public org.objectweb.asm.AnnotationVisitor visitTypeAnnotation(int typeRef, TypePath typePath, String descriptor, boolean visible) {
            ClassDependenciesVisitor.this.maybeAddDependentType(this.types, Type.getType((String)descriptor));
            return new AnnotationVisitor(this.types);
        }
    }

    private class MethodVisitor
    extends org.objectweb.asm.MethodVisitor {
        private final Set<String> types;

        protected MethodVisitor(Set<String> types) {
            super(589824);
            this.types = types;
        }

        public void visitLocalVariable(String name, String desc, String signature, Label start, Label end, int index) {
            ClassDependenciesVisitor.this.maybeAddClassTypesFromSignature(signature, ClassDependenciesVisitor.this.privateTypes);
            ClassDependenciesVisitor.this.maybeAddDependentType(ClassDependenciesVisitor.this.privateTypes, Type.getType((String)desc));
            super.visitLocalVariable(name, desc, signature, start, end, index);
        }

        public org.objectweb.asm.AnnotationVisitor visitAnnotation(String descriptor, boolean visible) {
            ClassDependenciesVisitor.this.maybeAddDependentType(this.types, Type.getType((String)descriptor));
            return new AnnotationVisitor(this.types);
        }

        public org.objectweb.asm.AnnotationVisitor visitParameterAnnotation(int parameter, String descriptor, boolean visible) {
            ClassDependenciesVisitor.this.maybeAddDependentType(this.types, Type.getType((String)descriptor));
            return new AnnotationVisitor(this.types);
        }

        public org.objectweb.asm.AnnotationVisitor visitTypeAnnotation(int typeRef, TypePath typePath, String descriptor, boolean visible) {
            ClassDependenciesVisitor.this.maybeAddDependentType(this.types, Type.getType((String)descriptor));
            return new AnnotationVisitor(this.types);
        }

        public void visitInvokeDynamicInsn(String name, String descriptor, Handle bootstrapMethodHandle, Object ... bootstrapMethodArguments) {
            if (this.tryHandleSpecialBootstrapMethod(BootstrapMethod.fromIndy(bootstrapMethodHandle, bootstrapMethodArguments))) {
                return;
            }
            ClassDependenciesVisitor.this.addTypesFromMethodDescriptor(ClassDependenciesVisitor.this.privateTypes, descriptor);
            ClassDependenciesVisitor.this.maybeAddDependentType(ClassDependenciesVisitor.this.privateTypes, Type.getObjectType((String)bootstrapMethodHandle.getOwner()));
            for (Object arg : bootstrapMethodArguments) {
                this.addDependentTypeFromBootstrapMethodArgument(arg);
            }
        }

        public void visitLdcInsn(Object value) {
            if (value instanceof ConstantDynamic) {
                this.addDependentTypesFromConstantDynamic((ConstantDynamic)value);
            }
        }

        private void addDependentTypesFromConstantDynamic(ConstantDynamic arg) {
            if (this.tryHandleSpecialBootstrapMethod(BootstrapMethod.fromConstantDynamic(arg))) {
                return;
            }
            ClassDependenciesVisitor.this.maybeAddDependentType(ClassDependenciesVisitor.this.privateTypes, Type.getObjectType((String)arg.getBootstrapMethod().getOwner()));
            for (int i = 0; i < arg.getBootstrapMethodArgumentCount(); ++i) {
                this.addDependentTypeFromBootstrapMethodArgument(arg.getBootstrapMethodArgument(i));
            }
        }

        private void addDependentTypeFromBootstrapMethodArgument(Object arg) {
            if (arg instanceof Type) {
                ClassDependenciesVisitor.this.maybeAddDependentType(ClassDependenciesVisitor.this.privateTypes, (Type)arg);
            } else if (arg instanceof Handle) {
                ClassDependenciesVisitor.this.maybeAddDependentType(ClassDependenciesVisitor.this.privateTypes, Type.getObjectType((String)((Handle)arg).getOwner()));
            } else if (arg instanceof ConstantDynamic) {
                this.addDependentTypesFromConstantDynamic((ConstantDynamic)arg);
            }
        }

        private boolean tryHandleSpecialBootstrapMethod(BootstrapMethod bootstrapMethod) {
            if (!bootstrapMethod.getHandle().equals((Object)CONSTANT_BOOTSTRAPS_INVOKE)) {
                return false;
            }
            if (bootstrapMethod.getArguments().size() != 2) {
                return false;
            }
            if (!CLASS_DESC_OF.equals(bootstrapMethod.getArguments().get(0))) {
                return false;
            }
            Object className = bootstrapMethod.getArguments().get(1);
            if (!(className instanceof String)) {
                return false;
            }
            ClassDependenciesVisitor.this.maybeAddDependentType(ClassDependenciesVisitor.this.privateTypes, Type.getObjectType((String)((String)className).replace('.', '/')));
            return true;
        }
    }

    private class AnnotationVisitor
    extends org.objectweb.asm.AnnotationVisitor {
        private final Set<String> types;

        public AnnotationVisitor(Set<String> types) {
            super(589824);
            this.types = types;
        }

        public void visit(String name, Object value) {
            if (value instanceof Type) {
                ClassDependenciesVisitor.this.maybeAddDependentType(this.types, (Type)value);
            }
        }

        public org.objectweb.asm.AnnotationVisitor visitArray(String name) {
            return this;
        }

        public org.objectweb.asm.AnnotationVisitor visitAnnotation(String name, String descriptor) {
            ClassDependenciesVisitor.this.maybeAddDependentType(this.types, Type.getType((String)descriptor));
            return this;
        }
    }
}

