/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.cache.internal;

import java.util.function.Supplier;
import org.gradle.cache.FileIntegrityViolationException;
import org.gradle.cache.ObjectHolder;

public class FileIntegrityViolationSuppressingObjectHolderDecorator<T>
implements ObjectHolder<T> {
    private final ObjectHolder<T> delegate;

    public FileIntegrityViolationSuppressingObjectHolderDecorator(ObjectHolder<T> delegate) {
        this.delegate = delegate;
    }

    @Override
    public T get() {
        try {
            return this.delegate.get();
        }
        catch (FileIntegrityViolationException e) {
            return null;
        }
    }

    @Override
    public void set(T newValue) {
        this.delegate.set(newValue);
    }

    @Override
    public T update(ObjectHolder.UpdateAction<T> updateAction) {
        return (T)this.doUpdate(updateAction, () -> this.delegate.update(updateAction));
    }

    @Override
    public T maybeUpdate(ObjectHolder.UpdateAction<T> updateAction) {
        return (T)this.doUpdate(updateAction, () -> this.delegate.maybeUpdate(updateAction));
    }

    private T doUpdate(ObjectHolder.UpdateAction<T> updateAction, Supplier<T> work) {
        try {
            return work.get();
        }
        catch (FileIntegrityViolationException e) {
            T newValue = updateAction.update(null);
            this.set(newValue);
            return newValue;
        }
    }
}

